unit fROR_Main;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   $Revision: 65 $  $Modtime: 5/01/07 11:07a $
*       Site:           Hines OIFO
*       Developers:
*                                      
*
*       Description:    Main application window
*
*       Notes:
*
================================================================================
*       $Archive: /CCR v1.5/Current/fROR_Main.pas $
*
* $History: fROR_Main.pas $
 * 
 * *****************  Version 65  *****************
 * User: Vhaishgavris Date: 5/01/07    Time: 3:20p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 64  *****************
 * User: Vhaishgavris Date: 3/08/07    Time: 1:47p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 63  *****************
 * User: Vhaishgavris Date: 2/13/07    Time: 3:41p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 62  *****************
 * User: Vhaishgavris Date: 6/15/06    Time: 8:24a
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 61  *****************
 * User: Vhaishgavris Date: 3/17/06    Time: 2:52p
 * Updated in $/CCR v1.5/Current
 * 
*
================================================================================
}
interface

uses
  ActnList, Classes, ComCtrls, Controls, Dialogs, Forms, ImgList, Menus,
  fROR_VistARegistries, StdActns, SysUtils, Windows, Messages, ovcstate,
  ovcbase, ovcfiler, ovcstore, uROR_VistAStore, uROR_Contextor,
  uROR_CustomContextor, VERGENCECONTEXTORLib_TLB, ExtCtrls, StdCtrls,
  AppEvnts, Graphics, AdvMenus, AdvMenuStylers, ExeInfo, OleCtrls,
  uROR_CustomBroker, uROR_Broker, uROR_CmdLineParams, Trpcb, CCOWRPCBroker,
  uROR_CCRCmdLine, uROR_HelpMgr;

type

  TFormMain = class(TForm)
    MainMenu: TAdvMainMenu;
    mnuFile: TMenuItem;
    mnuFileOpen: TMenuItem;
    mnuWindow: TMenuItem;
    mnuHelp: TMenuItem;
    N1: TMenuItem;
    mnuFileExit: TMenuItem;
    mnuWindowCascade: TMenuItem;
    mnuWindowTileH: TMenuItem;
    mnuWindowArrange: TMenuItem;
    mnuHelpAbout: TMenuItem;
    mnuWindowMinimize: TMenuItem;
    stsbrMain: TStatusBar;
    ActionList: TActionList;
    acFileExit: TAction;
    acFileOpen: TAction;
    acWindowCascade: TWindowCascade;
    acWindowTileHorizontal: TWindowTileHorizontal;
    acWindowArrangeAll: TWindowArrange;
    acWindowMinimizeAll: TWindowMinimizeAll;
    acHelpAbout: TAction;
    acWindowTileVertical: TWindowTileVertical;
    mnuWindowTileV: TMenuItem;
    ImageList: TImageList;
    acFileCloseAll: TAction;
    mnuFileCloseAll1: TMenuItem;
    acFileClose: TWindowClose;
    mnuFileClose: TMenuItem;
    acHelpTopics: TAction;
    N3: TMenuItem;
    mnuHelpTopics: TMenuItem;
    acFileSaveAs: TAction;
    N2: TMenuItem;
    mnuSaveAs: TMenuItem;
    N4: TMenuItem;
    acFilePrint: TAction;
    Print1: TMenuItem;
    acFilePageSetup: TAction;
    acFilePrintPreview: TAction;
    PageSetup1: TMenuItem;
    PrintPreview1: TMenuItem;
    OvcFormState: TOvcFormState;
    vxsFormLayout: TCCRVistAStore;
    ccrContextor: TCCRContextor;
    acFileBreakLink: TAction;
    acFileRejoinApp: TAction;
    acFileRejoinGlobal: TAction;
    N5: TMenuItem;
    mnuFileBreakLink: TMenuItem;
    mnuFileRejoin: TMenuItem;
    mnuFileRejoinLocal: TMenuItem;
    mnuFileRejoinGlobal: TMenuItem;
    acHelpCCOWStatus: TAction;
    N6: TMenuItem;
    mnuHelpCCOWStatus: TMenuItem;
    acFilePreferences: TAction;
    Preferences1: TMenuItem;
    N7: TMenuItem;
    amsMenuStyler: TAdvMenuOfficeStyler;
    ExeInfo: TExeInfo;
    ccrContextorIndicator: TCCRContextorIndicator;
    brkrCCOWRPCBroker: TCCOWRPCBroker;
    ccrBroker: TCCRBroker;
    acRPCLog: TAction;
    RPCLog1: TMenuItem;

    procedure acFileCloseAllExecute( Sender: TObject );
    procedure acFileExitExecute( Sender: TObject );
    procedure acFileOpenExecute( Sender: TObject );
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure acHelpAboutExecute(Sender: TObject);
    procedure acFileExitUpdate(Sender: TObject);
    procedure acFileSaveAsExecute(Sender: TObject);
    procedure acFilePrintExecute(Sender: TObject);
    procedure acHelpTopicsExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure acFilePageSetupExecute(Sender: TObject);
    procedure acFilePrintPreviewExecute(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure acFileCCOWUpdate(Sender: TObject);
    procedure acFileBreakLinkExecute(Sender: TObject);
    procedure acFileRejoinAppExecute(Sender: TObject);
    procedure acFileRejoinGlobalExecute(Sender: TObject);
    procedure ccrContextorPending(ASender: TObject;
      const aContextItemCollection: IDispatch);
    procedure ccrContextorPatientChanged(Sender: TObject);
    procedure ccrContextorCommitted(Sender: TObject);
    procedure acHelpCCOWStatusExecute(Sender: TObject);
    procedure ccrContextorSuspended(Sender: TObject);
    procedure ccrContextorResumed(Sender: TObject);
    procedure acFilePreferencesExecute(Sender: TObject);
    procedure VerifyVersions;
    procedure acRPCLogExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);

  public

    ccrCmdLineParams: TCCRCommandLineParameters;

    procedure CloseAllMDIChildren;
    function  Connect: Boolean;
    procedure CreateMDIChild( const RegistryName: String = '');
    procedure Disconnect;

    procedure LoadLayout;
    procedure SaveLayout;


  end;

procedure DisplayStatus(const msg: String);

var
  FormMain: TFormMain;

implementation
{$R *.DFM}

uses
  uROR_Utilities, fROR_MDIChild, fROR_GenericRegistry, fROR_HEPC, fROR_ICR,
  fROR_UserDefined, fROR_AboutDlg, uROR_Common, uROR_User,
  fROR_Options, uROR_Strings, CommCtrl, StrUtils, uROR_Debug
{$IFDEF RPCLOG}
  , fZZ_EventLog
{$ENDIF}
  ;

const
  RORContextName = 'ROR GUI';
  ROR_GUIVersion = '1.5.24';

procedure TFormMain.acFileCCOWUpdate(Sender: TObject);
begin
  acFileBreakLink.Enabled := (CCOWContextor.State = csParticipating);

  if CCOWContextor.State = csSuspended then
    begin
      acFileRejoinGlobal.Enabled := True;
      acFileRejoinGlobal.Enabled := True;
      mnuFileRejoin.Enabled      := True;
    end
  else
    begin
      acFileRejoinGlobal.Enabled := False;
      acFileRejoinGlobal.Enabled := False;
      mnuFileRejoin.Enabled      := False;
    end;
end;

procedure TFormMain.acFileBreakLinkExecute(Sender: TObject);
begin
  CCOWContextor.Suspend;
end;

procedure TFormMain.acFileCloseAllExecute(Sender: TObject);
begin
  CloseAllMDIChildren;
end;

procedure TFormMain.acFileExitExecute(Sender: TObject);
begin
  Close;
end;

procedure TFormMain.acFileExitUpdate(Sender: TObject);
var
  prst: Boolean;
begin
  acFileCloseAll.Enabled := (MDIChildCount > 0);
  acFileOpen.Enabled := (Broker <> nil);
  if Assigned(ActiveMDIChild) then
    begin
      prst := TFormMDIChild(ActiveMDIChild).CanBePrinted;
      acFilePrint.Enabled := prst;
      acFilePrintPreview.Enabled := prst;
      acFilePageSetup.Enabled := prst;
      acFileSaveAs.Enabled := TFormMDIChild(ActiveMDIChild).HasBeenModified;
    end
  else
    begin
      acFilePrint.Enabled := False;
      acFileSaveAs.Enabled := False;
    end;
end;

procedure TFormMain.acFileOpenExecute(Sender: TObject);
begin
  CreateMDIChild(CmdLineParams.RegistryName);
end;

procedure TFormMain.acFilePageSetupExecute(Sender: TObject);
begin
  if Assigned(ActiveMDIChild) then
    TFormMDIChild(ActiveMDIChild).PageSetup;
end;

procedure TFormMain.acFilePreferencesExecute(Sender: TObject);
begin
  CCROptions.Edit;
end;

procedure TFormMain.acFilePrintExecute(Sender: TObject);
begin
  if Assigned(ActiveMDIChild) then
    TFormMDIChild(ActiveMDIChild).Print;
end;

procedure TFormMain.acFilePrintPreviewExecute(Sender: TObject);
begin
  if Assigned(ActiveMDIChild) then
    TFormMDIChild(ActiveMDIChild).PrintPreview;
end;

procedure TFormMain.acFileRejoinAppExecute(Sender: TObject);
begin
  CCOWContextor.Resume(crmUseAppData);
end;

procedure TFormMain.acFileRejoinGlobalExecute(Sender: TObject);
begin
  CCOWContextor.Resume(crmUseGlobalData);
end;

procedure TFormMain.acFileSaveAsExecute(Sender: TObject);
begin
  if Assigned(ActiveMDIChild) then
    TFormMDIChild(ActiveMDIChild).SaveAs;
end;

procedure TFormMain.acHelpAboutExecute(Sender: TObject);
begin
  try
    GMVAboutDlg := TFormAboutDlg.Create(Application);
    GMVAboutDlg.Execute;
    GMVAboutDlg.Free;
  except
  end;
end;

procedure TFormMain.acHelpCCOWStatusExecute(Sender: TObject);
begin
  if CCRContextor <> nil then
    CCRContextor.DisplayStatus;
end;

procedure TFormMain.acHelpTopicsExecute(Sender: TObject);
begin
  Application.HelpCommand(HELP_INDEX, 0);
end;

procedure TFormMain.acRPCLogExecute(Sender: TObject);
begin
{$IFDEF RPCLOG}
  ShowEventLog(False);
{$ENDIF}
end;

procedure TFormMain.ccrContextorCommitted(Sender: TObject);
var
  i: Integer;
begin
  if Assigned(brkrCCOWRPCBroker) then
    if brkrCCOWRPCBroker.IsUserCleared and brkrCCOWRPCBroker.WasUserDefined then
      begin
        //--- Close modal dialogs and message boxes
        for i:=1 to Screen.CustomFormCount do
          begin
            if Screen.CustomForms[i-1] is TFormMain then
              Break;
            if fsModal in Screen.CustomForms[i-1].FormState then
              Screen.CustomForms[i-1].Close;
          end;
        //--- Terminate the application
        Application.Terminate;
      end;
end;

procedure TFormMain.ccrContextorPatientChanged(Sender: TObject);
var
  i: Integer;
begin
  for i := MDIChildCount - 1 downto 0 do
    if MDIChildren[I] is TFormMDIChild then
      with TFormMDIChild(MDIChildren[I]) do
        PatientChangeCommit(CCOWContextor);
end;

procedure TFormMain.ccrContextorPending(aSender: TObject;
  const aContextItemCollection: IDispatch);
var
  i: Integer;
  reason: WideString;
  newDFN, newICN: String;
  ctx: IContextItemCollection;
begin
  ctx := IContextItemCollection(aContextItemCollection);
  with CCOWContextor do
    begin
      PatientDFNFromContext(ctx, newDFN);
      PatientICNFromContext(ctx, newICN);
      if (newDFN <> PatientDFN) or (newICN <> PatientICN) then
        for i := MDIChildCount - 1 downto 0 do
          if MDIChildren[I] is TFormMDIChild then
            with TFormMDIChild(MDIChildren[I]) do
              begin
                reason := PatientChangePending(newDFN);
                if reason <> '' then
                  begin
                    SetSurveyResponse(reason);
                    Break;
                  end;
              end;
    end;
end;

procedure TFormMain.ccrContextorResumed(Sender: TObject);
var
  i: Integer;
begin
  for i := MDIChildCount - 1 downto 0 do
    if MDIChildren[I] is TFormMDIChild then
      TFormMDIChild(MDIChildren[I]).CCOWResumed;
end;

procedure TFormMain.ccrContextorSuspended(Sender: TObject);
var
  i: Integer;
begin
  for i := MDIChildCount - 1 downto 0 do
    if MDIChildren[I] is TFormMDIChild then
      TFormMDIChild(MDIChildren[I]).CCOWSuspended;
end;

procedure TFormMain.CloseAllMDIChildren;
var
  i: Integer;
begin
  for i := MDIChildCount - 1 downto 0 do
    MDIChildren[I].Close;
end;

function TFormMain.Connect: Boolean;
var
  stn: String;
  accType: Integer;
begin
  if Broker.Connected then
    Disconnect;

  Result := False;

  if Broker.Connect then
    try
      Application.BringToFront;

      Broker.RPCBroker.RpcVersion := ExeInfo.FileVersion;

      if Broker.CallProc(rpcIsRPCAvailable, [rpcGUIAccess],
           nil, nil, [rpcNoErrorCheck]) and
         (StrToIntDef(Broker.Results[0], 0) <> 0) then
        begin
          Result := True;

          //--- Determine type of the VistA account
          if not Broker.CallProc('ROR PRODUCTION ACCOUNT', []) then
            accType := -1
          else if StrToIntDef(Broker.Results[0], 0) <> 0 then
            accType := 1
          else
            accType := 0;

          //---  Load user info and GUI options
          TUserInfo.LoadCurrentUserInfo;
          CCROptions.Restore;
          CCROptions.Apply;

          //--- Initialize the CCOW contextor
          with CCOWContextor do
            begin
              stn := LeftStr(CCRUser.StationNumber, 3);
              if stn <> '' then
                begin
                  DFNItemName := Piece(DFNItemName, '_') + '_' + stn;
                  case accType of
                    -1: begin
                          NotRunningReason := RSC00162;
                          Enabled := False;
                        end;
                     0: DFNItemName := DFNItemName + '_test';
                  end;
                  ProcessKnownSubjects(True);
                end
              else
                begin
                  NotRunningReason := RSC00160;
                  Enabled := False;
                end;
            end;

          //--- ??? Error processing
          stsbrMain.Panels[1].Text := Format('  %s @ %d',
            [Broker.Server, Broker.ListenerPort]);
          stsbrMain.Panels[2].Text := '  ' + CCRUser.Name;

          //--- Restore main window size and state
          LoadLayout;

          //--- Check that the server version is at the minimum patch level
          //--- required by this client version.
          VerifyVersions;

          //--- Display the "Select a Registry" dialog or open the only
          //--- accessible (or enforced) registry automatically
          PostMessage(Handle, WM_COMMAND, mnuFileOpen.Command, 0);
        end
      else
        begin
          MessageDlg508('', Format(RSC00120, [rpcGUIAccess]), mtError, [mbOK], 0);
          Broker.Disconnect;
        end;
    except
      Broker.Disconnect;
      raise;
    end;
end;

procedure TFormMain.VerifyVersions;
var
  verM: string;
begin
  Broker.CreateResults;
  if Broker.CallProc(rpcGetMVersion, []) then
  begin
    verM := Broker.Results[0];

    // Check for match between GUI product version and M string being returned
    if verM <> ROR_GUIVersion then
      MessageDlg508('', Format(rscVersionMismatch, [verM, ROR_GUIVersion]), mtWarning, [mbOK], 0);
  end;
end;

procedure TFormMain.CreateMDIChild(const RegistryName: String);
var
  regInfo: TRegistryInfo;
begin
  regInfo := AvailableRegistries.Select( AnsiUpperCase(RegistryName) );
  if Assigned(regInfo) then
    if regInfo.Name = 'VA HEPC' then
      TFormHEPC.CreateRegistry(regInfo, Application)
    else if regInfo.Name = 'VA HIV' then
      TFormICR.CreateRegistry(regInfo, Application)
    else
      TFormUserDefined.CreateRegistry(regInfo, Application);
end;

procedure TFormMain.Disconnect;
begin
  CloseAllMDIChildren;
  if (Broker <> nil) and Broker.Connected then
    begin
      // Save size and state, and hide the main window
      SaveLayout;
      Hide;
      // Disconnect the RPC Broker
      Broker.Disconnect;
    end;
end;

procedure TFormMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Disconnect;
  Action := caFree;
end;

procedure TFormMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := True;
  {$IFNDEF AANTEST}
  if not Application.Terminated then
    CanClose := (MessageDlg508('', RSC00121, mtConfirmation, [mbYes, mbNo], 0) = mrYes);
  {$ENDIF}
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
  LoadHelpFile('CCR', 'CCR.HLP', ROR_GUIVersion);
  ccrCmdLineParams := TCCRCommandLineParameters.Create(Self);

  { If command-line parameters help is requested, the applicattion will be
    closed after dispalying the help dialog box (see the CCRCompDemo.dpr).
    So, there is no need to perform any additional initialization. }
  if CmdLineParams.Help then
    Exit;

  { Link broker and contextor to the command-line parameters component. }
  CCOWContextor.CmdLineParams := ccrCmdLineParams;
  Broker.CmdLineParams := ccrCmdLineParams;

  { Create a debug log if the application is started in debug mode. Otherwise,
    a "dummy" log instance is created implicitly and any debug/trace output is
    discarded. }
  if CmdLineParams.DebugMode then
    TCCRDebugLog.Create;

  { Try to start the contextor and connect to the vault. If the Sentillion
    contextor is not installed on the users workstation or the vault is not
    available then the TCCRContextor will switch to idle mode and all requests
    will be ignored. }
  if CmdLineParams.NoCCOW then
    CCOWContextor.NotRunningReason := RSC00161
  else
    CCOWContextor.Run;

  { Append the CCOW application instance identifier to the application title. }
  if CCOWContextor.State <> csNotRunning then
    Application.Title := Application.Title + ' (#' +
      Piece(CCOWContextor.ApplicationName, '#', 2) + ')';

{$IFDEF RPCLOG}
  RPCLog1.Visible := True;
{$ENDIF}
end;

procedure TFormMain.FormShow(Sender: TObject);
begin
  { Force the help file to be set again. This addresses an issue where the first
    time the copied local help file is loaded or after it is updated it is not
    being set. }
  LoadHelpFile('CCR', 'CCR.HLP', ROR_GUIVersion);
end;

procedure TFormMain.FormResize(Sender: TObject);
var
  i, wd: Integer;
  sbpr: TRect;
begin
  wd := stsbrMain.Width;
  for i:=stsbrMain.Panels.Count-1 downto 1 do
    wd := wd - stsbrMain.Panels[i].Width;
  stsbrMain.Panels[0].Width := wd;

  //--- Place the CCOW contextor indicator on the status bar
  stsbrMain.Perform(SB_GETRECT, 3, LPARAM(@sbpr));
  with ccrContextorIndicator do
    begin
      Parent := stsbrMain;
      Left   := sbpr.Left + (sbpr.Right  - sbpr.Left - Width)  div 2;
      Top    := sbpr.Top  + (sbpr.Bottom - sbpr.Top  - Height) div 2;
    end;
end;

procedure TFormMain.LoadLayout;
begin
  if Assigned(OvcFormState) then
    OvcFormState.RestoreState;
end;

procedure TFormMain.SaveLayout;
begin
  if Assigned(OvcFormState) then
    OvcFormState.SaveState;
end;

procedure DisplayStatus(const msg: String);
begin
  if Assigned(FormMain) then
    with FormMain.stsbrMain do
      begin
        Panels[0].Text := msg;
        Repaint;
      end;
end;

end.
